<?php

namespace frontend\controllers;

use Yii;
use common\models\Auditors;
use common\models\AuditorsSearch;
use common\models\AuditorCertificates;
use common\models\AuditorCertificatesSearch;
use common\models\AuditorNaceCodes;
use common\models\AuditorNaceCodesSearch;
use common\models\AuditorCertificateCategories;
use common\models\AuditorCertificateCategoriesSearch;
use common\models\AuditorCertificatesFiles;
use common\models\AuditorCertificatesFilesSearch;
use common\models\DeletedRecords;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * AuditorsController implements the CRUD actions for Auditors model.
 */
class AuditorsController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Auditors models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new AuditorsSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        $internalAuditorSearchModel = new AuditorsSearch();
        $internalAuditorSearchModel->auditor_categories_id = 1;
        $internalAuditors = $internalAuditorSearchModel->search($this->request->queryParams);

        $externalAuditorSearchModel = new AuditorsSearch();
        $externalAuditorSearchModel->auditor_categories_id = 2;
        $externalAuditors = $externalAuditorSearchModel->search($this->request->queryParams);

        $technicalExpertSearchModel = new AuditorsSearch();
        $technicalExpertSearchModel->auditor_categories_id = 3;
        $technicalExperts = $technicalExpertSearchModel->search($this->request->queryParams);

        $committeeMemberSearchModel = new AuditorsSearch();
        $committeeMemberSearchModel->auditor_categories_id = 4;
        $committeeMembers = $committeeMemberSearchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'internalAuditors' => $internalAuditors,
            'externalAuditors' => $externalAuditors,
            'technicalExperts' => $technicalExperts,
            'committeeMembers' => $committeeMembers,
        ]);
    }

    /**
     * Displays a single Auditors model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $auditorCertificatesSearchModel = new AuditorCertificatesSearch();
        $auditorCertificatesSearchModel->auditors_id = $id;
        $auditorCertificates = $auditorCertificatesSearchModel->search([]);

        $auditorNaceCodesSearchModel = new AuditorNaceCodesSearch();
        $auditorNaceCodesSearchModel->auditors_id = $id;
        $auditorNaceCodes = $auditorNaceCodesSearchModel->search([]);

        $auditorCertificateCategoriesSearchModel = new AuditorCertificateCategoriesSearch();
        $auditorCertificateCategoriesSearchModel->auditors_id = $id;
        $auditorCertificateCategories = $auditorCertificateCategoriesSearchModel->search([]);

        return $this->render('view', [
            'model' => $this->findModel($id),
            'auditorCertificates' => $auditorCertificates,
            'auditorNaceCodes' => $auditorNaceCodes,
            'auditorCertificateCategories' => $auditorCertificateCategories,
        ]);
    }

    /**
     * Creates a new Auditors model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Auditors();

        if ($model->load(Yii::$app->request->post())) {

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('create', ['model' => $model,]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Auditors model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('update', ['model' => $model,]);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Auditors model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $auditor = Auditors::findOne($id);

        $deleted_record = $auditor->full_name;
        
        try {
            $auditor->delete();
        } catch (\yii\db\Exception $e) {
            return 0;
        }

        // Adding details to deleted records table
        $deletedItem = new DeletedRecords();

        $deletedItem->area_name= "Auditor";
        $deletedItem->deleted_record = $deleted_record;
        $deletedItem->created_by=Yii::$app->user->identity->id;
        $deletedItem->created_on=date('Y-m-d H:i:s');
        $deletedItem->save();
        
        return 1;
    }

    /**
     * Finds the Auditors model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return Auditors the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Auditors::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

        /**
     * Creates a new AuditorCertificates model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddcertificate($auditors_id)
    {
        $model = new AuditorCertificates();
        $model->auditors_id = $auditors_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->auditors_name = $model->auditors->full_name;
            $model->certification_category_name = $model->certificates->certification_category_name;
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $auditors_id]);
            }
            else
            {
                return $this->render('add-certificate', ['model' => $model,]);
            }
        } else {
            return $this->render('add-certificate', [
                'model' => $model,
            ]);
        }
    }

        /**
     * Displays a single AuditorCertificates model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewauditorcertificate($auditor_certificates_id)
    {
        $auditorCertificate = AuditorCertificates::findOne($auditor_certificates_id);

        $auditorCertificatesFilesSearchModel = new AuditorCertificatesFilesSearch();
        $auditorCertificatesFilesSearchModel->auditor_certificates_id = $auditor_certificates_id;

        $auditorCertificatesFiles = $auditorCertificatesFilesSearchModel->search([]);

        return $this->render('view-certificate', [
            'model' => $this->findModel($auditorCertificate->auditors_id),
            'auditorCertificate' => $auditorCertificate,
            'auditorCertificatesFiles' => $auditorCertificatesFiles,
        ]);
    }

         /**
     * Creates a new AuditorCertificatesFiles model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionUploaddocuments($auditor_certificates_id)
    { 
        $model = new AuditorCertificatesFiles();
        $model->auditor_certificates_id = $auditor_certificates_id;

        if ($model->load(Yii::$app->request->post())) {

            $total = count($_FILES['AuditorCertificatesFiles']['name']); // multiple files
            $path = Yii::$app->basePath .'/web/uploads/auditor_certificate_documents/'; // your upload path

            if($total >0 )
            {
                $tmpFilePath = $_FILES['AuditorCertificatesFiles']['tmp_name']['auditor_certificates_file']; // the temp file path
                $fileName = $_FILES['AuditorCertificatesFiles']['name']['auditor_certificates_file']; // the file name
                $fileSize = $_FILES['AuditorCertificatesFiles']['size']['auditor_certificates_file']; // the file size

                if ($tmpFilePath != ""){
                    //Setup our new file path
                    $newFilePath = $path .'acd_'.$model->id.'_'. $fileName;
                    $newFileUrl = Yii::$app->basePath .'/web/uploads/auditor_certificate_documents/' . $fileName;
                    
                    //Upload the file into the new path
                    if(move_uploaded_file($tmpFilePath, $newFilePath)) {
                        $fileId = $fileName . '1985'; // some unique key to identify the file
                        $preview[] = $newFileUrl;
                        $config[] = [
                            'key' => $fileId,
                            'caption' => $fileName,
                            'size' => $fileSize,
                            'downloadUrl' => $newFileUrl, // the url to download the file
                        ];
                    } else {
                        $errors[] = $fileName;
                    }
                } else {
                    $errors[] = $fileName;
                }
            }

            if($fileName)
            {
                $model->auditor_certificates_file = 'acd_'.$model->id.'_'.$fileName;
                $model->created_by=Yii::$app->user->identity->id;
                $model->created_on=date('Y-m-d H:i:s');
                $model->edited_by=Yii::$app->user->identity->id;
                $model->edited_on=date('Y-m-d H:i:s');

                if ($model->save())
                {                    
                    $auditorCertificate = AuditorCertificates::findOne($auditor_certificates_id);

                    $auditorCertificatesFilesSearchModel = new AuditorCertificatesFilesSearch();
                    $auditorCertificatesFilesSearchModel->auditor_certificates_id = $auditor_certificates_id;

                    $auditorCertificatesFiles = $auditorCertificatesFilesSearchModel->search([]);

                    Yii::$app->session->setFlash('uploadSuccess', 'The file uploaded successfully.');

                    return $this->render('view-certificate', [
                        'model' => $this->findModel($auditorCertificate->auditors_id),
                        'auditorCertificate' => $auditorCertificate,
                        'auditorCertificatesFiles' => $auditorCertificatesFiles,
                    ]);

                } else {
                    return $this->render('add-document', ['model' => $model,]);
                }
            }
        } else {
            return $this->render('add-document', [
                'model' => $model,
            ]);
        }

    }

                /**
     * Displays a single Phases model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionAdddocuments($auditor_certificates_files_id)
    {
        $auditorCertificateDocumentFile = AuditorCertificatesFiles::findOne($auditor_certificates_files_id);

        return $this->render('add-document', [
            'model' => $auditorCertificateDocumentFile,
        ]);
    }

        /**
     * Deletes an existing Industries model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDeletedocument($auditor_certificates_files_id)
    {
        $auditorCertificateDocumentFile = AuditorCertificatesFiles::findOne($auditor_certificates_files_id);

        $deleted_record = $auditorCertificateDocumentFile->auditor_certificates_file;
        try {
            $auditorCertificateDocumentFile->delete();
        } catch (\yii\db\Exception $e) {
            return 0;
        }

        // Adding details to deleted records table
        $deletedItem = new DeletedRecords();

        $deletedItem->area_name= "Auditor Certificate Documents";
        $deletedItem->deleted_record = $deleted_record;
        $deletedItem->created_by=Yii::$app->user->identity->id;
        $deletedItem->created_on=date('Y-m-d H:i:s');
        $deletedItem->save();
        
        return 1;
    }

       /**
     * Creates a new AuditorNaceCodes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddnacecode($auditors_id)
    {
        $model = new AuditorNaceCodes();
        $model->auditors_id = $auditors_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->auditors_name = $model->auditors->full_name;
            $model->nace_code_name = $model->naceCodes->nace_code_name;
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $auditors_id]);
            }
            else
            {
                return $this->render('add-nace-code', ['model' => $model,]);
            }
        } else {
            return $this->render('add-nace-code', [
                'model' => $model,
            ]);
        }
    }

      /**
     * Creates a new AuditorCertificateCategories model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddcertificatecategory($auditors_id)
    {
        $model = new AuditorCertificateCategories();
        $model->auditors_id = $auditors_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->auditors_name = $model->auditors->full_name;
            $model->category_name = $model->certificateCategories->category_name;
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $auditors_id]);
            }
            else
            {
                return $this->render('add-certificate-category', ['model' => $model,]);
            }
        } else {
            return $this->render('add-certificate-category', [
                'model' => $model,
            ]);
        }
    }
}
