<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\AuditDocumentsFilesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Audit Documents Files';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="audit-documents-files-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Audit Documents Files', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'audit_documents_id',
            'audit_documents_file',
            'created_on',
            'created_by',
            //'edited_on',
            //'edited_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, AuditDocumentsFiles $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
