<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use kartik\dialog\Dialog;

echo Dialog::widget([
  'libName' => 'krajeeDialog',
  'options' => ['draggable' => true, 'closable' => true], 
]);

/* @var $this yii\web\View */
/* @var $searchModel common\models\AuditorsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Manage Resource Personals';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage Resource Personals</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Resource Personals</li>
        </ol>
        <?= Html::a('<i class="fas fa-plus"></i> New Resource Person', ['/auditors/create'], ['class' => 'btn btn-primary float-sm-right mr-5']) ?>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
          <div class="card">
            <div class="card-header">
              <?= Html::a('Internal Auditors', ['/auditors/index', '#' => 'internal-auditors'], ['class' => 'btn btn-primary mr-2']) ?>
              <?= Html::a('External Auditors', ['/auditors/index', '#' => 'external-auditors'], ['class' => 'btn btn-primary mr-2']) ?>
              <?= Html::a('Technical Expert', ['/auditors/index', '#' => 'technical-experts'], ['class' => 'btn btn-primary mr-2']) ?>
              <?= Html::a('Committee Member', ['/auditors/index', '#' => 'committee-members'], ['class' => 'btn btn-primary mr-2']) ?>
            </div>
          </div>
          <div class="card">
            <div class="card-header" id="internal-auditors">
              <h3 class="card-title">Manage Internal Auditors</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="internal-auditors-table" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>Full Name</th>
                  <th>Email</th>
                  <th>Phone</th>
                  <th>Postal Address</th>
                  <th>Joined Date</th>
                  <th>Active</th>
                  <th></th>
                </tr>
                </thead>
                <tbody>

                <?php foreach($internalAuditors->getModels() as $internalAuditor): ?>

                <tr>
                  <td><?= Html::encode($internalAuditor->full_name); ?></td>
                  <td><?= Html::encode($internalAuditor->email_address); ?></td>
                  <td><?= Html::encode($internalAuditor->contact_phone); ?></td>
                  <td><?= Html::encode($internalAuditor->postal_address); ?></td>
                  <td><?= Html::encode($internalAuditor->joined_date); ?></td>
                  <td>
                      <input type="checkbox" style="margin-left:5px;" name="accredited<?=$internalAuditor['id']?>" id="accredited<?=$internalAuditor['id']?>" 
                        <?= ($internalAuditor['active']==1 ? 'checked' : '');?>
                      >
                  </td>
                  <td>
                    <?= Html::a('<i class="far fa-eye"></i>', ['/auditors/view','id' => $internalAuditor->id], ['class' => 'btn btn-info']) ?>
                    <?= Html::a('<i class="far fa-edit"></i>', ['/auditors/update','id' => $internalAuditor->id], ['class' => 'btn btn-warning']) ?>
                    <button class="btn btn-danger" id="btnDelete<?= Html::encode($internalAuditor->id)?>" onclick="deleteAuditor(<?= Html::encode($internalAuditor->id)?>);" ><i class="far fa-trash-alt"></i></button>
                  </td>
                </tr>

                <?php endforeach ?>
                
                </tbody>
                <tfoot>
                <tr>
                  <th>Full Name</th>
                  <th>Email</th>
                  <th>Phone</th>
                  <th>Postal Address</th>
                  <th>Joined Date</th>
                  <th>Active</th>
                  <th></th>
                </tr>
                </tfoot>
              </table>
            </div>
            <!-- /.card-body -->
            <div class="card-header" id="external-auditors">
              <h3 class="card-title">Manage External Auditors</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="external-auditors-table" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>Full Name</th>
                  <th>Email</th>
                  <th>Phone</th>
                  <th>Postal Address</th>
                  <th>Joined Date</th>
                  <th>Active</th>
                  <th></th>
                </tr>
                </thead>
                <tbody>

                <?php foreach($externalAuditors->getModels() as $externalAuditor): ?>

                <tr>
                  <td><?= Html::encode($externalAuditor->full_name); ?></td>
                  <td><?= Html::encode($externalAuditor->email_address); ?></td>
                  <td><?= Html::encode($externalAuditor->contact_phone); ?></td>
                  <td><?= Html::encode($externalAuditor->postal_address); ?></td>
                  <td><?= Html::encode($externalAuditor->joined_date); ?></td>
                  <td>
                      <input type="checkbox" style="margin-left:5px;" name="accredited<?=$internalAuditor['id']?>" id="accredited<?=$internalAuditor['id']?>" 
                        <?= ($internalAuditor['active']==1 ? 'checked' : '');?>
                      >
                  </td>
                  <td>
                    <?= Html::a('<i class="far fa-eye"></i>', ['/auditors/view','id' => $externalAuditor->id], ['class' => 'btn btn-info']) ?>
                    <?= Html::a('<i class="far fa-edit"></i>', ['/auditors/update','id' => $externalAuditor->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i>', ['/auditors/delete','id' => $externalAuditor->id], ['class' => 'btn btn-danger']) ?>
                  </td>
                </tr>

                <?php endforeach ?>
                
                </tbody>
                <tfoot>
                <tr>
                  <th>Full Name</th>
                  <th>Email</th>
                  <th>Phone</th>
                  <th>Postal Address</th>
                  <th>Joined Date</th>
                  <th>Active</th>
                  <th></th>
                </tr>
                </tfoot>
              </table>
            </div>
            <!-- /.card-body -->
            <div class="card-header" id="technical-experts">
              <h3 class="card-title">Manage Technical Exports</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="technical-experts-table" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>Full Name</th>
                  <th>Email</th>
                  <th>Phone</th>
                  <th>Postal Address</th>
                  <th>Joined Date</th>
                  <th>Active</th>
                  <th></th>
                </tr>
                </thead>
                <tbody>

                <?php foreach($technicalExperts->getModels() as $technicalExpert): ?>

                <tr>
                  <td><?= Html::encode($technicalExpert->full_name); ?></td>
                  <td><?= Html::encode($technicalExpert->email_address); ?></td>
                  <td><?= Html::encode($technicalExpert->contact_phone); ?></td>
                  <td><?= Html::encode($technicalExpert->postal_address); ?></td>
                  <td><?= Html::encode($technicalExpert->joined_date); ?></td>
                  <td>
                      <input type="checkbox" style="margin-left:5px;" name="accredited<?=$internalAuditor['id']?>" id="accredited<?=$internalAuditor['id']?>" 
                        <?= ($internalAuditor['active']==1 ? 'checked' : '');?>
                      >
                  </td>
                  <td>
                    <?= Html::a('<i class="far fa-eye"></i>', ['/auditors/view','id' => $technicalExpert->id], ['class' => 'btn btn-info']) ?>
                    <?= Html::a('<i class="far fa-edit"></i>', ['/auditors/update','id' => $technicalExpert->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i>', ['/auditors/delete','id' => $technicalExpert->id], ['class' => 'btn btn-danger']) ?>
                  </td>
                </tr>

                <?php endforeach ?>
                
                </tbody>
                <tfoot>
                <tr>
                  <th>Full Name</th>
                  <th>Email</th>
                  <th>Phone</th>
                  <th>Postal Address</th>
                  <th>Joined Date</th>
                  <th>Active</th>
                  <th></th>
                </tr>
                </tfoot>
              </table>
            </div>
            <!-- /.card-body -->
            <div class="card-header" id="committee-members">
              <h3 class="card-title">Manage Committee Members</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="committee-members-table" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>Full Name</th>
                  <th>Email</th>
                  <th>Phone</th>
                  <th>Postal Address</th>
                  <th>Joined Date</th>
                  <th>Active</th>
                  <th></th>
                </tr>
                </thead>
                <tbody>

                <?php foreach($committeeMembers->getModels() as $committeeMember): ?>

                <tr>
                  <td><?= Html::encode($committeeMember->full_name); ?></td>
                  <td><?= Html::encode($committeeMember->email_address); ?></td>
                  <td><?= Html::encode($committeeMember->contact_phone); ?></td>
                  <td><?= Html::encode($committeeMember->postal_address); ?></td>
                  <td><?= Html::encode($committeeMember->joined_date); ?></td>
                  <td>
                      <input type="checkbox" style="margin-left:5px;" name="accredited<?=$internalAuditor['id']?>" id="accredited<?=$internalAuditor['id']?>" 
                        <?= ($internalAuditor['active']==1 ? 'checked' : '');?>
                      >
                  </td>
                  <td>
                    <?= Html::a('<i class="far fa-eye"></i>', ['/auditors/view','id' => $committeeMember->id], ['class' => 'btn btn-info']) ?>
                    <?= Html::a('<i class="far fa-edit"></i>', ['/auditors/update','id' => $committeeMember->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i>', ['/auditors/delete','id' => $committeeMember->id], ['class' => 'btn btn-danger']) ?>
                  </td>
                </tr>

                <?php endforeach ?>
                
                </tbody>
                <tfoot>
                <tr>
                  <th>Full Name</th>
                  <th>Email</th>
                  <th>Phone</th>
                  <th>Postal Address</th>
                  <th>Joined Date</th>
                  <th>Active</th>
                  <th></th>
                </tr>
                </tfoot>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
          <div class="card">
            <div class="card-header">
              <?= Html::a('Internal Auditors', ['/auditors/index', '#' => 'internal-auditors'], ['class' => 'btn btn-primary mr-2']) ?>
              <?= Html::a('External Auditors', ['/auditors/index', '#' => 'external-auditors'], ['class' => 'btn btn-primary mr-2']) ?>
              <?= Html::a('Technical Expert', ['/auditors/index', '#' => 'technical-experts'], ['class' => 'btn btn-primary mr-2']) ?>
              <?= Html::a('Committee Member', ['/auditors/index', '#' => 'committee-members'], ['class' => 'btn btn-primary mr-2']) ?>
            </div>
          </div>
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#internal-auditors-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });

    $("#external-auditors-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });

    $("#technical-experts-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });

    $("#committee-members-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });

  function deleteAuditor(id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this resource person?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=auditors/delete&id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected resource person as it is in use.');
              }
              else {
                window.location.replace("index.php?r=auditors");
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }
</script>

