<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\CustomerCertificatesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Customer Certificates';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="customer-certificates-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Customer Certificates', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'customers_id',
            'certificates_id',
            'customers_name',
            'accreditation',
            //'created_on',
            //'created_by',
            //'edited_on',
            //'edited_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, CustomerCertificates $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
