<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\CustomersHistorySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Customers Histories';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="customers-history-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Customers History', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'customers_id',
            'name',
            'head_office_address',
            'first_contact',
            //'first_contact_phone_1',
            //'second_contact',
            //'second_contact_phone_1',
            //'site_address',
            //'joined_date',
            //'created_on',
            //'created_by',
            //'edited_on',
            //'edited_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, CustomersHistory $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
