<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\CustomersHistory */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Customers Histories', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="customers-history-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'customers_id',
            'name',
            'head_office_address',
            'first_contact',
            'first_contact_phone_1',
            'second_contact',
            'second_contact_phone_1',
            'site_address',
            'joined_date',
            'created_on',
            'created_by',
            'edited_on',
            'edited_by',
        ],
    ]) ?>

</div>
