<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Certificates;
use common\models\CertificateCategories;
use common\models\NaceCodes;
use common\models\IafCodes;

/* @var $this yii\web\View */
/* @var $model common\models\CustomerCertificates */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-certificates-form">

    <?php $form = ActiveForm::begin(); ?>

        <?= $form->field($model, 'customers_id')->hiddenInput()->label(false); ?>
        <?= $form->field($model->customers, 'name')->textInput(['maxlength' => true,'readonly'=> true]) ?>

        <?= $form->field($model, 'certificate_categories_id')->dropDownList(
            ArrayHelper::map(CertificateCategories::find()->all(),'id','category_name'), ['prompt'=>'Select a certificate category', 'onchange'=>'
            UpdateDropdownsForCategory($(this).val())'])?> 

        <?= $form->field($model, 'certificates_id')->dropDownList(
            ArrayHelper::map(Certificates::find()->all(),'id','reference_standard'), ['prompt'=>'Select a reference standard'])?>

        <?= $form->field($model, 'nace_codes_id')->dropDownList(
            ArrayHelper::map(NaceCodes::find()->all(),'id','nace_code_name'), ['prompt'=>'Select a NACE code', 'onchange'=>'
            GetIAFCodeForNACECode($(this).val())'])?>

        <?= $form->field($model, 'iaf_codes_id')->dropDownList(
            ArrayHelper::map(IafCodes::find()->all(),'id','iaf_code'), ['prompt'=>'Select an IAF code'])?>
            
        <?= $form->field($model, 'accreditation')->checkBox() ?>

        <?= $form->field($model, 'multisite')->checkBox() ?>

        <?= $form->field($model, 'secondary')->checkBox() ?>

        <?= $form->field($model, 'parent_certificate_categories_id')->dropDownList(
            ArrayHelper::map(CertificateCategories::find()->all(),'id','category_name'), ['prompt'=>'Select the parent certificate category', 'onchange'=>'
            UpdateDropdownsForParentCategory($(this).val())'])?> 

        <?= $form->field($model, 'parent_certificates_id')->dropDownList(
            ArrayHelper::map(Certificates::find()->all(),'id','reference_standard'), ['prompt'=>'Select the parent reference standard'])?>

        <div class="form-group">
            <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
        </div>

    <?php ActiveForm::end(); ?>

</div>


<script>
        function UpdateDropdownsForCategory(certificate_categories_id)
        {
                $.post( "index.php?r=customers/list_certificates_for_category&certificate_categories_id=" + certificate_categories_id, function( data ) {
                        $("select#customercertificates-certificates_id").html(data);
        });
        }

        function UpdateDropdownsForParentCategory(parent_certificate_categories_id)
        {
                $.post( "index.php?r=customers/list_certificates_for_category&certificate_categories_id=" + parent_certificate_categories_id, function( data ) {
                        $("select#customercertificates-parent_certificates_id").html(data);
        });
        }

        function GetIAFCodeForNACECode(nace_codes_id)
        {
                $.post( "index.php?r=customers/get_iaf_code_for_nace_code&nace_codes_id=" + nace_codes_id, function( data ) {
                        $("select#customercertificates-iaf_codes_id").val(data['iaf_codes_id']);
                });
        }

</script>