<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;
use common\models\Cycles;

/* @var $this yii\web\View */
/* @var $model common\models\CustomerCertificates */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-certificates-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'customer_certificates_id')->hiddenInput()->label(false); ?>
    <?= $form->field($model->customerCertificates->customers, 'name')->textInput(['maxlength' => true,'readonly'=> true]) ?>
    <?= $form->field($model->customerCertificates->certificates, 'certification_category_name')->textInput(['maxlength' => true,'readonly'=> true]) ?>

    <?= $form->field($model, 'cycles_id')->dropDownList(
            ArrayHelper::map(Cycles::find()->all(),'id','cycle_name'), ['prompt'=>'Select a cycle'])?>
    
    <?= $form->field($model, 'filing_name')->textInput(['maxlength' => true, 'onkeyup' => 'displayFilingNameLength()', 'style' => 'text-transform: uppercase;']) ?>

    <div class="form-group">
        <input type="text" class="form-control" style="width:20%;" id="filing-count" name="filing-count" value="" disabled>
    </div>
    
    <?= $form->field($model, 'committee_approval_date')->widget(
            DatePicker::className(),[
                'name' => 'committee_approval_date',
                'type' => DatePicker::TYPE_COMPONENT_APPEND,
                'pluginOptions' => [
                    'autoclose'=>true,
                    'format' => 'yyyy-mm-dd'
                ]
            ]
        );?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
        <?= Html::a('Cancel', ['customers/viewcycle','audit_cycles_id' => $model->id], ['class' => 'btn btn-danger']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<script>
    displayFilingNameLength();

    function displayFilingNameLength()
    {
        var filingName = document.getElementById("auditcycles-filing_name").value;
        document.getElementById("filing-count").value = filingName.length + "/20";
    }
</script>