<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Customers */

$this->title = $model->name.' - '. $auditCycle->cycles->cycle_name;
$this->params['breadcrumbs'][] = ['label' => 'Customers Certificate', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Customers', ['index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Customer Certificates', ['view', 'id' => $model->id]) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Audit Cycles', ['viewcustomercertificate', 'customer_certificates_id' => $auditCycle->customer_certificates_id]) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($this->title) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-edit"></i> Edit', ['updatecycle', 'audit_cycles_id' => $auditCycle->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i> Delete', ['delete', 'id' => $auditCycle->id], [
                        'class' => 'btn btn-danger',
                        'data' => [
                            'confirm' => 'Are you sure you want to delete this audit cycle?',
                            'method' => 'post',
                        ],
                    ]) ?>
                    <?= Html::a('<i class="fas fa-plus"></i> Add Audit Phase', ['addphase', 'audit_cycles_id' => $auditCycle->id], ['class' => 'btn btn-success']) ?>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Customers', ['index'], ['class' => 'btn btn-info']) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="form-group mb-3">
                  <div class="row">
                    <dl class="row col-md-6">
                        <dt class="col-sm-6">
                            <?= $model->getAttributeLabel('name') ?>
                        </dt>
                        <dd class="col-sm-6">
                            <?= $model->name ?>
                        </dd>
                        <dt class="col-sm-6">
                            <?= $auditCycle->customerCertificates->certificates->getAttributeLabel('certification_category_name') ?>
                        </dt>
                        <dd class="col-sm-6">
                            <?= $auditCycle->customerCertificates->certificates->certification_category_name ?>
                        </dd>
                        <dt class="col-sm-6">
                            <?= $auditCycle->customerCertificates->certificates->getAttributeLabel('reference_standard') ?>
                        </dt>
                        <dd class="col-sm-6">
                            <?= $auditCycle->customerCertificates->certificates->reference_standard ?>
                        </dd>
                        <dt class="col-sm-6">
                            <?= $auditCycle->customerCertificates->getAttributeLabel('accreditation') ?>
                        </dt>
                        <dd class="col-sm-6">
                        <?= $auditCycle->customerCertificates->accreditation == 1 ? 'Yes' : 'No' ?>
                        </dd>
                    </dl>

                    <dl class="row col-md-6">
                        <dt class="col-sm-6">
                            <?= $auditCycle->cycles->getAttributeLabel('cycle_name') ?>
                        </dt>
                        <dd class="col-sm-6">
                            <?= $auditCycle->cycles->cycle_name ?>
                        </dd>
                        <dt class="col-sm-6">
                            <?= $auditCycle->getAttributeLabel('filing_name') ?>
                        </dt>
                        <dd class="col-sm-6">
                            <?= $auditCycle->filing_name ?>
                        </dd>
                        <dt class="col-sm-6">
                            <?= $auditCycle->getAttributeLabel('committee_approval_date') ?>
                        </dt>
                        <dd class="col-sm-6">
                            <?= $auditCycle->committee_approval_date ?>
                        </dd>
                    </dl>
                  </div>
                </div>
              </div>
              <!-- /.card-body -->
              <div class="card-body">
                <table id="cycles-table" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>Audit Phase</th>
                        <th>Calling Date</th>
                        <th>Schedule Date</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($auditPhases->getModels() as $auditPhase): ?>

                        <tr>
                        <td><?= Html::encode($auditPhase->phases_name); ?></td>
                        <td><?= Html::encode($auditPhase->calling_date); ?></td>
                        <td><?= Html::encode($auditPhase->schedule_date); ?></td>
                        <td>
                            <?= Html::a('<i class="fa fa-fw fa-paper-plane"></i>', ['customers/viewphase','audit_phases_id' => $auditPhase->id], ['class' => 'btn btn-primary']) ?>
                            <?= Html::a('<i class="far fa-edit"></i>', ['customers/updatephase','audit_phases_id' => $auditPhase->id], ['class' => 'btn btn-warning']) ?>
                            <?= Html::a('<i class="far fa-trash-alt"></i>', ['/client-locations/delete','id' => $auditPhase->id], ['class' => 'btn btn-danger']) ?>
                        </td>
                        </tr>

                    <?php endforeach ?>
                                            
                    </tbody>
                  <tfoot>
                    <tr>
                        <th>Audit Phase</th>
                        <th>Calling Date</th>
                        <th>Schedule Date</th>
                        <th></th>
                    </tr>
                  </tfoot>
                </table>`
              
              </div>
        </div>
        <!-- /.card -->
    </div>
    <!-- /.col -->
</div>
