<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use yii\widgets\DetailView;
use kartik\file\FileInput;
use kartik\dialog\Dialog;

echo Dialog::widget([
  'libName' => 'krajeeDialog',
  'options' => ['draggable' => true, 'closable' => true], 
]);

/* @var $this yii\web\View */
/* @var $model common\models\Customers */

$this->title = $model->name.' > '. $auditPhase->certificates->certification_category_name.' > '. $auditPhase->auditCycles->cycles->cycle_name.' > '.$auditPhase->phases->name;
$this->params['breadcrumbs'][] = ['label' => 'Customers Certificate', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Customers', ['index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Customer Certificates', ['view', 'id' => $model->id]) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Audit Cycles', ['viewcustomercertificate', 'customer_certificates_id' => $auditPhase->auditCycles->customer_certificates_id]) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Audit Phases', ['viewcycle', 'audit_cycles_id' => $auditPhase->auditCycles->id]) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($auditPhase->phases->name) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-edit"></i> Edit Phase', ['updatephase', 'audit_phases_id' => $auditPhase->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i> Delete', ['delete', 'id' => $model->id], [
                        'class' => 'btn btn-danger',
                        'data' => [
                            'confirm' => 'Are you sure you want to delete this audit phase?',
                            'method' => 'post',
                        ],
                    ]) ?>
                    <?= Html::a('<i class="fas fa-plus"></i> Add Document Type', ['adddocumenttype', 'audit_phases_id' => $auditPhase->id], ['class' => 'btn btn-primary']) ?>
                    <?= Html::a('<i class="fas fa-plus"></i> Add Auditor', ['addauditor', 'audit_phases_id' => $auditPhase->id], ['class' => 'btn btn-success']) ?>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Audit Phases', ['viewcycle', 'audit_cycles_id' => $auditPhase->auditCycles->id], ['class' => 'btn btn-info']) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="form-group mb-3">
                  
                  <div class="row">
                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->name ?>
                        </dd>
                      </dl>
                    </div>

                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->auditCycles->customerCertificates->getAttributeLabel('accreditation') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->auditCycles->customerCertificates->accreditation == 1 ? 'Yes' : 'No' ?>
                        </dd>
                      </dl>
                    </div>
                    
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->auditCycles->customerCertificates->certificates->getAttributeLabel('certification_category_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->auditCycles->customerCertificates->certificates->certification_category_name ?>
                        </dd>
                      </dl>
                    </div>

                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->auditCycles->customerCertificates->certificates->getAttributeLabel('certification_category_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->auditCycles->customerCertificates->certificates->certification_category_name ?>
                        </dd>
                      </dl>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->auditCycles->cycles->getAttributeLabel('cycle_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->auditCycles->cycles->cycle_name ?>
                        </dd>
                      </dl>
                    </div>

                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->phases->getAttributeLabel('name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->phases->name ?>
                        </dd>
                      </dl>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->getAttributeLabel('calling_date') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->calling_date == '' ? '<i>- Date not set -</i>' : $auditPhase->calling_date ?>
                        </dd>
                      </dl>
                    </div>

                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->getAttributeLabel('schedule_date') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->schedule_date == '' ? '<i>- Date not set -</i>' : $auditPhase->schedule_date ?>
                        </dd>
                      </dl>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->getAttributeLabel('actual_start_date') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->actual_start_date == '' ? '<i>- Date not set -</i>' : $auditPhase->actual_start_date ?>
                        </dd>
                      </dl>
                    </div>

                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->getAttributeLabel('actual_end_date') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->actual_end_date == '' ? '<i>- Date not set -</i>' : $auditPhase->actual_end_date ?>
                        </dd>
                      </dl>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <dl>
                        <dt class="col-sm-3">
                            <?= $auditPhase->getAttributeLabel('audit_status_id') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditPhase->auditStatus->status_name ?>
                        </dd>
                      </dl>
                    </div>

                    <div class="col-md-6">
                      
                    </div>
                  </div>

                </div>
              </div>
              <div class="card-header">
                <h2 class="card-title text-primary">Audit Documents</h2>
              </div>
              <!-- /.card-body -->
              <div class="card-body">
                <table id="documents-table" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>Document Type</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($auditDocuments->getModels() as $auditDocument): ?>

                        <tr>
                        <td><?= Html::encode($auditDocument->document_types_name); ?></td>
                        <td>
                            <?= Html::a('<i class="far fa-file-alt"></i>', ['customers/viewdocuments','audit_documents_id' => $auditDocument->id], ['class' => 'btn btn-warning']) ?>
                            <button class="btn btn-danger" id="btnDelete<?= Html::encode($auditDocument->id)?>" onclick="deleteDocumentType(<?= Html::encode($auditDocument->id)?>,<?= Html::encode($auditDocument->audit_phases_id)?>);" ><i class="far fa-trash-alt"></i></button>     
                        </td>
                        </tr>

                    <?php endforeach ?>
                                            
                    </tbody>
                  <tfoot>
                    <tr>
                        <th>Document Type</th>
                        <th></th>
                    </tr>
                  </tfoot>
                </table>
              
              </div>
              <div class="card-header">
                <h2 class="card-title text-primary">Auditors</h2>
                <?= Html::a('<i class="fas fa-plus"></i> Add Auditors', ['addauditor', 'audit_phases_id' => $auditPhase->id], ['class' => 'btn btn-success float-sm-right mr-5']) ?>

              </div>
              <div class="card-body">
                <table id="auditors-table" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>Auditor</th>
                        <th>Attended</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($phaseAuditors->getModels() as $phaseAuditor): ?>

                        <tr>
                        <td><?= Html::encode($phaseAuditor->auditors_name); ?></td>
                        <td>
                            <input type="checkbox" style="margin-left:5px;" 
                              name="is_attended<?=$phaseAuditor->id?>" 
                              id="is_attended<?=$phaseAuditor->id ?>" 
                              onchange="attendanceChange(<?=$phaseAuditor->id?>)"
                              <?= ($phaseAuditor->attended==1 ? 'checked' : '');?>
                              <?= ($auditPhase->audit_status_id == 2) ? '' : 'disabled'?>
                            >
                        </td>
                        <td>
                            <?= Html::a('<i class="far fa-trash-alt"></i>', 
                              ['customers/deleteauditor','phase_auditors_id' => $phaseAuditor->id], 
                              ['class' => 'btn btn-danger',
                                'data' => [
                                  'confirm' => 'Are you sure you want to delete this auditor?',
                                  'method' => 'post',
                              ],]) ?>
                        </td>
                        </tr>

                    <?php endforeach ?>
                                            
                    </tbody>
                  <tfoot>
                    <tr>
                        <th>Auditor</th>
                        <th>Attended</th>
                        <th></th>
                    </tr>
                  </tfoot>
                </table>
              
              </div>
        </div>
        <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#documents-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });

    $("#auditors-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });

  function attendanceChange(id)
  {
    var is_attended = (document.getElementById('is_attended'+id).checked ==1)?1:0;

    $.ajax({
      url:'index.php?r=customers/updateattendance&id='+id+'&is_attended='+is_attended,
      method:'post',
      dataType:'json',
      success:function(data){
        console.log(data);
      }
    });
  }

  function deleteDocumentType(id, audit_phases_id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this document?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=customers/deletedocumenttype&audit_documents_id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected document type as it is in use.');
              }
              else {
                window.location.replace("index.php?r=customers/viewphase&audit_phases_id="+audit_phases_id);
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }
</script>