<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Cycles;
use common\models\Phases;
use common\models\DocumentTypes;

/* @var $this yii\web\View */
/* @var $model common\models\DefaultDocuments */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-certificates-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'cycles_id')->dropDownList(
            ArrayHelper::map(Cycles::find()->all(),'id','cycle_name'), ['prompt'=>'Select a cycle'])?>

    <?= $form->field($model, 'phases_id')->dropDownList(
            ArrayHelper::map(Phases::find()->all(),'id','name'), ['prompt'=>'Select a phase'])?>

    <?= $form->field($model, 'document_types_id')->dropDownList(
            ArrayHelper::map(DocumentTypes::find()->all(),'id','name'), ['prompt'=>'Select a document'])?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
