<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model common\models\Certificates */

$this->title = 'Manage Default Documents';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage Default Documents</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Default Documents</li>
        </ol>
        <?= Html::a('<i class="fas fa-plus"></i> New document', ['/default-documents/create'], ['class' => 'btn btn-primary float-sm-right mr-5']) ?>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage default documents</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="default-documents-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Cycle</th>
                    <th>Phase</th>
                    <th>Document</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $defaultDocuments): ?>

                  <tr>
                    <td><?= Html::encode($defaultDocuments->cycles->cycle_name); ?></td>
                    <td><?= Html::encode($defaultDocuments->phases->name); ?></td>
                    <td><?= Html::encode($defaultDocuments->document_types_name); ?></td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/default-documents/view','id' => $defaultDocuments->id], ['class' => 'btn btn-info']) ?>
                      <?= Html::a('<i class="far fa-edit"></i>', ['/default-documents/update','id' => $defaultDocuments->id], ['class' => 'btn btn-warning']) ?>
                      <?= Html::a('<i class="far fa-trash-alt"></i>', ['/default-documents/delete','id' => $defaultDocuments->id], ['class' => 'btn btn-danger']) ?>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                  <th>Cycle</th>
                    <th>Phase</th>
                    <th>Document</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {

    var groupColumn1 = 0;

    $("#default-documents-table").DataTable({
      "responsive": true,
      "autoWidth": false,
      "order": [[ groupColumn1, 'asc' ] ],
      "displayLength": 100,
      "columnDefs": [
            { "visible": false, "targets": groupColumn1 }
        ],
      "drawCallback": function ( settings ) {
            var api = this.api();
            var rows = api.rows( {page:'current'} ).nodes();
            var last=null;
 
            api.column(groupColumn1, {page:'current'} ).data().each( function ( group, i ) {
                if ( last !== group ) {
                    $(rows).eq( i ).before(
                        '<tr class="group"><td colspan="4">'+group+'</td></tr>'
                    );
 
                    last = group;
                }
            } );
        }
    });

  });
</script>