<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\DocumentTypes */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Document Types', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Document Types', ['index']) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($this->title) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <p>
                    
                    <?= Html::a('<i class="far fa-edit"></i> Edit', ['update', 'id' => $model->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i> Delete', ['delete', 'id' => $model->id], [
                        'class' => 'btn btn-danger',
                        'data' => [
                            'confirm' => 'Are you sure you want to delete this document type?',
                            'method' => 'post',
                        ],
                    ]) ?>
                    <?= Html::a('<i class="fas fa-plus"></i> Add Document', ['adddocument', 'document_types_id' => $model->id], ['class' => 'btn btn-success']) ?>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Document Types', ['index'], ['class' => 'btn btn-info']) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                
                <div class="form-group mb-3">
                    <dl class="row">
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->name ?>
                        </dd>
                    </dl>
                </div>
              </div>
              <!-- /.card-body -->
              <div class="card-body">
                <table id="document-type-revisions-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Issue. No</th>
                    <th>Issue Date</th>
                    <th>Revision. No</th>
                    <th>Revision Date</th>
                    <th>Document</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($documentTypeRevisions as $documentTypeRevision): ?>

                  <tr>
                    <td><?= Html::encode($documentTypeRevision['issue_no']); ?></td>
                    <td><?= Html::encode($documentTypeRevision['issue_date']); ?></td>
                    <td><?= Html::encode($documentTypeRevision['revision_no']); ?></td>
                    <td><?= Html::encode($documentTypeRevision['revision_date']); ?></td>
                    <td><?= Html::encode($documentTypeRevision['file_name']); ?></td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/document-type-revisions/view','id' => $documentTypeRevision['document_types_id']], ['class' => 'btn btn-info']) ?>
                      <?= Html::a('<i class="far fa-trash-alt"></i>', ['/document-type-revisions/delete','id' => $documentTypeRevision['document_types_id']], ['class' => 'btn btn-danger']) ?>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Issue. No</th>
                    <th>Issue Date</th>
                    <th>Revision. No</th>
                    <th>Revision Date</th>
                    <th>Document</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>
