<?php

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use yii\grid\GridView;
use yii\widgets\Pjax;
use common\models\Customers;
use common\models\Certificates;
use common\models\Cycles;
use common\models\AuditPhases;

/* @var $this yii\web\View */
/* @var $model common\models\Customers */

$this->title = 'Global Search';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Global Search</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Global Search</li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Search for customers and certificates</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <?php $form = ActiveForm::begin([
                    'options' => [
                        'class' => 'needs-validation',
                        'novalidate' => true,
                        ]
                ]); ?>
                  <div class="row">
                    <div class="col-md-3">
                      <?= $form->field($searchModel, 'customers_id')->dropDownList(
                        ArrayHelper::map(Customers::find()->all(),'id','name'), ['prompt'=>'Select a customer'])?>
                    </div>
                    <div class="col-md-3">
                      <?= $form->field($searchModel, 'certificates_id')->dropDownList(
                                  ArrayHelper::map(Certificates::find()->all(),'id','certification_category_name'), ['prompt'=>'Select a certificate'])?>
                    </div>
                    <div class="col-md-3">
                      <?= $form->field($searchModel, 'audit_cycles_id')->dropDownList(
                        ArrayHelper::map(Cycles::find()->all(),'id','cycle_name'), ['prompt'=>'Select a cycle'])?>
                    </div>
                    <div class="col-md-3">
                      <?= $form->field($searchModel, 'audit_phases_id')->dropDownList(
                                  ArrayHelper::map(AuditPhases::find()->all(),'id','phases_name'), ['prompt'=>'Select a phase'])?>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-3">
                      <?= $form->field($searchModel, 'accreditation')->checkBox() ?>
                    </div>
                  </div>
                  <div class="form-group">
                      <?= Html::submitButton('Search', ['class' => 'btn btn-success']) ?>
                  </div>
                
                <?php ActiveForm::end(); ?>
              </div>
              <!-- /.card-body -->
              <div class="card-header">
                <h2 class="card-title text-primary">Customers</h2>
              </div>
              <div class="card-body">
                  <table id="customer-table" class="table table-bordered table-striped">
                      <thead>
                          <tr>
                              <th>Customer</th>
                          </tr>
                      </thead>
                      <tbody>

                      <?php foreach($customersList as $customer): ?>

                      <tr>
                          <td><?= Html::a($customer['customers_name'], ['/customers/view','id' => $customer['customers_id']]) ?></td>
                      </tr>

                      <?php endforeach ?>
                    
                      </tbody>
                      <tfoot>
                          <tr>
                              <th>Customer</th>
                          </tr>
                      </tfoot>
                  </table>
              </div>
              <div class="card-header">
                <h2 class="card-title text-primary">Customers and Certificates</h2>
              </div>
              <div class="card-body">
                  <table id="customer-certificate-table" class="table table-bordered table-striped">
                      <thead>
                          <tr>
                              <th>Customer</th>
                              <th>Certificate</th>
                              <th>Is Accredited</th>
                          </tr>
                      </thead>
                      <tbody>

                      <?php foreach($customerCertificatesList as $customerCertificate): ?>

                      <tr>
                          <td><?= Html::a($customerCertificate['customers_name'], ['/customers/view','id' => $customerCertificate['customers_id']]) ?></td>
                          <td><?= Html::a($customerCertificate['certification_category_name'], ['/customers/viewcustomercertificate','customer_certificates_id' => $customerCertificate['customer_certificates_id']]) ?></td>
                          <td><?= $customerCertificate['accreditation'] == 1 ? 'Yes' : 'No' ?></td>
                      </tr>

                      <?php endforeach ?>
                    
                      </tbody>
                      <tfoot>
                          <tr>
                              <th>Customer</th>
                              <th>Certificate</th>
                              <th>Is Accredited</th>
                          </tr>
                      </tfoot>
                  </table>
              </div>
              <div class="card-header">
                <h2 class="card-title text-primary">Audit Cycles and Phases</h2>
              </div>
              <div class="card-body">
                  <table id="audit-phases-table" class="table table-bordered table-striped">
                      <thead>
                          <tr>
                              <th>Customer</th>
                              <th>Certificate</th>
                              <th>Is Accredited</th>
                              <th>Cycle</th>
                              <th>Phase</th>
                              <th>Status</th>
                          </tr>
                      </thead>
                      <tbody>

                      <?php foreach($phasesCyclesList as $phasesCycle): ?>

                      <tr>
                          <td><?= Html::a($phasesCycle['customers_name'], ['/customers/view','id' => $phasesCycle['customers_id']]) ?></td>
                          <td><?= Html::a($phasesCycle['certification_category_name'], ['/customers/viewcustomercertificate','customer_certificates_id' => $phasesCycle['customer_certificates_id']]) ?></td>
                          <td><?= $phasesCycle['accreditation'] == 1 ? 'Yes' : 'No' ?></td>
                          <td><?= Html::a($phasesCycle['cycle_name'], ['/customers/viewcycle','audit_cycles_id' => $phasesCycle['audit_cycles_id']]) ?></td>
                          <td><?= Html::a($phasesCycle['phases_name'], ['/customers/viewphase','audit_phases_id' => $phasesCycle['id']]) ?></td>
                          <td><?= $phasesCycle['status_name'] ?></td>
                      </tr>

                      <?php endforeach ?>
                    
                      </tbody>
                      <tfoot>
                          <tr>
                              <th>Customer</th>
                              <th>Certificate</th>
                              <th>Is Accredited</th>
                              <th>Cycle</th>
                              <th>Phase</th>
                              <th>Status</th>
                          </tr>
                      </tfoot>
                  </table>
              </div>
              <div class="card-header">
                <h2 class="card-title text-primary">Audit Documents</h2>
              </div>
              <div class="card-body">
                  <table id="audit-documents-table" class="table table-bordered table-striped">
                      <thead>
                          <tr>
                              <th>Customer</th>
                              <th>Certificate</th>
                              <th>Is Accredited</th>
                              <th>Cycle</th>
                              <th>Phase</th>
                              <th>Document Type</th>
                          </tr>
                      </thead>
                      <tbody>

                      <?php foreach($auditDocuments as $auditDocument): ?>

                      <tr>
                          <td><?= Html::a($auditDocument['customers_name'], ['/customers/view','id' => $auditDocument['customers_id']]) ?></td>
                          <td><?= Html::a($auditDocument['certification_category_name'], ['/customers/viewcustomercertificate','customer_certificates_id' => $auditDocument['customer_certificates_id']]) ?></td>
                          <td><?= $auditDocument['accreditation'] == 1 ? 'Yes' : 'No' ?></td>
                          <td><?= Html::a($auditDocument['cycle_name'], ['/customers/viewcycle','audit_cycles_id' => $auditDocument['audit_cycles_id']]) ?></td>
                          <td><?= Html::a($auditDocument['phases_name'], ['/customers/viewphase','audit_phases_id' => $auditDocument['audit_phases_id']]) ?></td>
                          <td><?= Html::encode($auditDocument['document_types_name']); ?></td>
                      </tr>

                      <?php endforeach ?>
                    
                      </tbody>
                      <tfoot>
                          <tr>
                              <th>Customer</th>
                              <th>Certificate</th>
                              <th>Is Accredited</th>
                              <th>Cycle</th>
                              <th>Phase</th>
                              <th>Document Type</th>
                          </tr>
                      </tfoot>
                  </table>
              </div>
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#customer-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });

    $("#customer-certificate-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });

    $("#audit-phases-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });

    $("#audit-documents-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });
</script>