<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model common\models\Cycles */

$this->title = 'Manage User Roles';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage User Roles</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage User Roles</li>
        </ol>
        <?= Html::a('<i class="fas fa-plus"></i> New User Role', ['/user-roles/create'], ['class' => 'btn btn-primary float-sm-right mr-5']) ?>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage users</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="user-roles-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Role</th>
                    <th>Full View</th>
                    <th>View</th>
                    <th>Download</th>
                    <th>Print</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $userRole): ?>

                  <tr>
                    <td><?= Html::encode($userRole->role_name); ?></td>
                    <td>
                        <input type="checkbox" style="margin-left:5px;" <?= ($userRole->allow_full_view==1 ? 'checked' : '');?> onclick="return false;">
                    </td>
                    <td>
                        <input type="checkbox" style="margin-left:5px;" <?= ($userRole->allow_view==1 ? 'checked' : '');?> onclick="return false;">
                    </td>
                    <td>
                        <input type="checkbox" style="margin-left:5px;" <?= ($userRole->allow_download==1 ? 'checked' : '');?> onclick="return false;">
                    </td>
                    <td>
                        <input type="checkbox" style="margin-left:5px;" <?= ($userRole->allow_print==1 ? 'checked' : '');?> onclick="return false;">
                    </td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/user-roles/view','id' => $userRole->id], ['class' => 'btn btn-info']) ?>
                      <?= Html::a('<i class="far fa-edit"></i>', ['/user-roles/update','id' => $userRole->id], ['class' => 'btn btn-warning']) ?>
                      <?= Html::a('<i class="far fa-trash-alt"></i>', ['/user-roles/delete','id' => $userRole->id], ['class' => 'btn btn-danger']) ?>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Role</th>
                    <th>Full View</th>
                    <th>View</th>
                    <th>Download</th>
                    <th>Print</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#user-roles-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });
</script>